<?php
/**
 * MultiButtonOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * MultiButtonOptions Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MultiButtonOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MultiButtonOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'icon_background_color' => 'string',
        'icon_color' => 'string',
        'label_text_open' => 'string',
        'label_text_color_open' => 'string',
        'label_background_color_open' => 'string',
        'label_text_close' => 'string',
        'label_text_color_close' => 'string',
        'label_background_color_close' => 'string',
        'icon_type_open' => 'string',
        'icon_text_open' => 'string',
        'icon_background_image_open' => 'string',
        'icon_class_open' => 'string',
        'icon_color_open' => 'string',
        'icon_background_color_open' => 'string',
        'icon_enabled_open' => 'string',
        'icon_type_close' => 'string',
        'icon_text_close' => 'string',
        'icon_background_image_close' => 'string',
        'icon_class_close' => 'string',
        'icon_color_close' => 'string',
        'icon_background_color_close' => 'string',
        'icon_enabled_close' => 'string',
        'default_state' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'icon_background_color' => null,
        'icon_color' => null,
        'label_text_open' => null,
        'label_text_color_open' => null,
        'label_background_color_open' => null,
        'label_text_close' => null,
        'label_text_color_close' => null,
        'label_background_color_close' => null,
        'icon_type_open' => null,
        'icon_text_open' => null,
        'icon_background_image_open' => null,
        'icon_class_open' => null,
        'icon_color_open' => null,
        'icon_background_color_open' => null,
        'icon_enabled_open' => null,
        'icon_type_close' => null,
        'icon_text_close' => null,
        'icon_background_image_close' => null,
        'icon_class_close' => null,
        'icon_color_close' => null,
        'icon_background_color_close' => null,
        'icon_enabled_close' => null,
        'default_state' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'icon_background_color' => false,
        'icon_color' => false,
        'label_text_open' => false,
        'label_text_color_open' => false,
        'label_background_color_open' => false,
        'label_text_close' => false,
        'label_text_color_close' => false,
        'label_background_color_close' => false,
        'icon_type_open' => false,
        'icon_text_open' => false,
        'icon_background_image_open' => false,
        'icon_class_open' => false,
        'icon_color_open' => false,
        'icon_background_color_open' => false,
        'icon_enabled_open' => false,
        'icon_type_close' => false,
        'icon_text_close' => false,
        'icon_background_image_close' => false,
        'icon_class_close' => false,
        'icon_color_close' => false,
        'icon_background_color_close' => false,
        'icon_enabled_close' => false,
        'default_state' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'icon_background_color' => 'iconBackgroundColor',
        'icon_color' => 'iconColor',
        'label_text_open' => 'labelTextOpen',
        'label_text_color_open' => 'labelTextColorOpen',
        'label_background_color_open' => 'labelBackgroundColorOpen',
        'label_text_close' => 'labelTextClose',
        'label_text_color_close' => 'labelTextColorClose',
        'label_background_color_close' => 'labelBackgroundColorClose',
        'icon_type_open' => 'iconTypeOpen',
        'icon_text_open' => 'iconTextOpen',
        'icon_background_image_open' => 'iconBackgroundImageOpen',
        'icon_class_open' => 'iconClassOpen',
        'icon_color_open' => 'iconColorOpen',
        'icon_background_color_open' => 'iconBackgroundColorOpen',
        'icon_enabled_open' => 'iconEnabledOpen',
        'icon_type_close' => 'iconTypeClose',
        'icon_text_close' => 'iconTextClose',
        'icon_background_image_close' => 'iconBackgroundImageClose',
        'icon_class_close' => 'iconClassClose',
        'icon_color_close' => 'iconColorClose',
        'icon_background_color_close' => 'iconBackgroundColorClose',
        'icon_enabled_close' => 'iconEnabledClose',
        'default_state' => 'defaultState'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'icon_background_color' => 'setIconBackgroundColor',
        'icon_color' => 'setIconColor',
        'label_text_open' => 'setLabelTextOpen',
        'label_text_color_open' => 'setLabelTextColorOpen',
        'label_background_color_open' => 'setLabelBackgroundColorOpen',
        'label_text_close' => 'setLabelTextClose',
        'label_text_color_close' => 'setLabelTextColorClose',
        'label_background_color_close' => 'setLabelBackgroundColorClose',
        'icon_type_open' => 'setIconTypeOpen',
        'icon_text_open' => 'setIconTextOpen',
        'icon_background_image_open' => 'setIconBackgroundImageOpen',
        'icon_class_open' => 'setIconClassOpen',
        'icon_color_open' => 'setIconColorOpen',
        'icon_background_color_open' => 'setIconBackgroundColorOpen',
        'icon_enabled_open' => 'setIconEnabledOpen',
        'icon_type_close' => 'setIconTypeClose',
        'icon_text_close' => 'setIconTextClose',
        'icon_background_image_close' => 'setIconBackgroundImageClose',
        'icon_class_close' => 'setIconClassClose',
        'icon_color_close' => 'setIconColorClose',
        'icon_background_color_close' => 'setIconBackgroundColorClose',
        'icon_enabled_close' => 'setIconEnabledClose',
        'default_state' => 'setDefaultState'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'icon_background_color' => 'getIconBackgroundColor',
        'icon_color' => 'getIconColor',
        'label_text_open' => 'getLabelTextOpen',
        'label_text_color_open' => 'getLabelTextColorOpen',
        'label_background_color_open' => 'getLabelBackgroundColorOpen',
        'label_text_close' => 'getLabelTextClose',
        'label_text_color_close' => 'getLabelTextColorClose',
        'label_background_color_close' => 'getLabelBackgroundColorClose',
        'icon_type_open' => 'getIconTypeOpen',
        'icon_text_open' => 'getIconTextOpen',
        'icon_background_image_open' => 'getIconBackgroundImageOpen',
        'icon_class_open' => 'getIconClassOpen',
        'icon_color_open' => 'getIconColorOpen',
        'icon_background_color_open' => 'getIconBackgroundColorOpen',
        'icon_enabled_open' => 'getIconEnabledOpen',
        'icon_type_close' => 'getIconTypeClose',
        'icon_text_close' => 'getIconTextClose',
        'icon_background_image_close' => 'getIconBackgroundImageClose',
        'icon_class_close' => 'getIconClassClose',
        'icon_color_close' => 'getIconColorClose',
        'icon_background_color_close' => 'getIconBackgroundColorClose',
        'icon_enabled_close' => 'getIconEnabledClose',
        'default_state' => 'getDefaultState'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ICON_TYPE_OPEN__DEFAULT = 'DEFAULT';
    public const ICON_TYPE_OPEN_CUSTOM = 'CUSTOM';
    public const ICON_TYPE_OPEN_FONT = 'FONT';
    public const ICON_TYPE_OPEN_SVG = 'SVG';
    public const ICON_TYPE_OPEN_FONT_MATERIAL = 'FONT_MATERIAL';
    public const ICON_TYPE_CLOSE__DEFAULT = 'DEFAULT';
    public const ICON_TYPE_CLOSE_CUSTOM = 'CUSTOM';
    public const ICON_TYPE_CLOSE_FONT = 'FONT';
    public const ICON_TYPE_CLOSE_SVG = 'SVG';
    public const ICON_TYPE_CLOSE_FONT_MATERIAL = 'FONT_MATERIAL';
    public const DEFAULT_STATE_CLOSED = 'CLOSED';
    public const DEFAULT_STATE_EXPANDED = 'EXPANDED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIconTypeOpenAllowableValues()
    {
        return [
            self::ICON_TYPE_OPEN__DEFAULT,
            self::ICON_TYPE_OPEN_CUSTOM,
            self::ICON_TYPE_OPEN_FONT,
            self::ICON_TYPE_OPEN_SVG,
            self::ICON_TYPE_OPEN_FONT_MATERIAL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIconTypeCloseAllowableValues()
    {
        return [
            self::ICON_TYPE_CLOSE__DEFAULT,
            self::ICON_TYPE_CLOSE_CUSTOM,
            self::ICON_TYPE_CLOSE_FONT,
            self::ICON_TYPE_CLOSE_SVG,
            self::ICON_TYPE_CLOSE_FONT_MATERIAL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDefaultStateAllowableValues()
    {
        return [
            self::DEFAULT_STATE_CLOSED,
            self::DEFAULT_STATE_EXPANDED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('icon_background_color', $data ?? [], null);
        $this->setIfExists('icon_color', $data ?? [], null);
        $this->setIfExists('label_text_open', $data ?? [], null);
        $this->setIfExists('label_text_color_open', $data ?? [], null);
        $this->setIfExists('label_background_color_open', $data ?? [], null);
        $this->setIfExists('label_text_close', $data ?? [], null);
        $this->setIfExists('label_text_color_close', $data ?? [], null);
        $this->setIfExists('label_background_color_close', $data ?? [], null);
        $this->setIfExists('icon_type_open', $data ?? [], null);
        $this->setIfExists('icon_text_open', $data ?? [], null);
        $this->setIfExists('icon_background_image_open', $data ?? [], null);
        $this->setIfExists('icon_class_open', $data ?? [], null);
        $this->setIfExists('icon_color_open', $data ?? [], null);
        $this->setIfExists('icon_background_color_open', $data ?? [], null);
        $this->setIfExists('icon_enabled_open', $data ?? [], null);
        $this->setIfExists('icon_type_close', $data ?? [], null);
        $this->setIfExists('icon_text_close', $data ?? [], null);
        $this->setIfExists('icon_background_image_close', $data ?? [], null);
        $this->setIfExists('icon_class_close', $data ?? [], null);
        $this->setIfExists('icon_color_close', $data ?? [], null);
        $this->setIfExists('icon_background_color_close', $data ?? [], null);
        $this->setIfExists('icon_enabled_close', $data ?? [], null);
        $this->setIfExists('default_state', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getIconTypeOpenAllowableValues();
        if (!is_null($this->container['icon_type_open']) && !in_array($this->container['icon_type_open'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'icon_type_open', must be one of '%s'",
                $this->container['icon_type_open'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getIconTypeCloseAllowableValues();
        if (!is_null($this->container['icon_type_close']) && !in_array($this->container['icon_type_close'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'icon_type_close', must be one of '%s'",
                $this->container['icon_type_close'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getDefaultStateAllowableValues();
        if (!is_null($this->container['default_state']) && !in_array($this->container['default_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'default_state', must be one of '%s'",
                $this->container['default_state'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets icon_background_color
     *
     * @return string|null
     * @deprecated
     */
    public function getIconBackgroundColor()
    {
        return $this->container['icon_background_color'];
    }

    /**
     * Sets icon_background_color
     *
     * @param string|null $icon_background_color See *Open and *Close variants
     *
     * @return self
     * @deprecated
     */
    public function setIconBackgroundColor($icon_background_color)
    {
        if (is_null($icon_background_color)) {
            throw new \InvalidArgumentException('non-nullable icon_background_color cannot be null');
        }
        $this->container['icon_background_color'] = $icon_background_color;

        return $this;
    }

    /**
     * Gets icon_color
     *
     * @return string|null
     * @deprecated
     */
    public function getIconColor()
    {
        return $this->container['icon_color'];
    }

    /**
     * Sets icon_color
     *
     * @param string|null $icon_color See *Open and *Close variants
     *
     * @return self
     * @deprecated
     */
    public function setIconColor($icon_color)
    {
        if (is_null($icon_color)) {
            throw new \InvalidArgumentException('non-nullable icon_color cannot be null');
        }
        $this->container['icon_color'] = $icon_color;

        return $this;
    }

    /**
     * Gets label_text_open
     *
     * @return string|null
     */
    public function getLabelTextOpen()
    {
        return $this->container['label_text_open'];
    }

    /**
     * Sets label_text_open
     *
     * @param string|null $label_text_open label_text_open
     *
     * @return self
     */
    public function setLabelTextOpen($label_text_open)
    {
        if (is_null($label_text_open)) {
            throw new \InvalidArgumentException('non-nullable label_text_open cannot be null');
        }
        $this->container['label_text_open'] = $label_text_open;

        return $this;
    }

    /**
     * Gets label_text_color_open
     *
     * @return string|null
     */
    public function getLabelTextColorOpen()
    {
        return $this->container['label_text_color_open'];
    }

    /**
     * Sets label_text_color_open
     *
     * @param string|null $label_text_color_open label_text_color_open
     *
     * @return self
     */
    public function setLabelTextColorOpen($label_text_color_open)
    {
        if (is_null($label_text_color_open)) {
            throw new \InvalidArgumentException('non-nullable label_text_color_open cannot be null');
        }
        $this->container['label_text_color_open'] = $label_text_color_open;

        return $this;
    }

    /**
     * Gets label_background_color_open
     *
     * @return string|null
     */
    public function getLabelBackgroundColorOpen()
    {
        return $this->container['label_background_color_open'];
    }

    /**
     * Sets label_background_color_open
     *
     * @param string|null $label_background_color_open label_background_color_open
     *
     * @return self
     */
    public function setLabelBackgroundColorOpen($label_background_color_open)
    {
        if (is_null($label_background_color_open)) {
            throw new \InvalidArgumentException('non-nullable label_background_color_open cannot be null');
        }
        $this->container['label_background_color_open'] = $label_background_color_open;

        return $this;
    }

    /**
     * Gets label_text_close
     *
     * @return string|null
     */
    public function getLabelTextClose()
    {
        return $this->container['label_text_close'];
    }

    /**
     * Sets label_text_close
     *
     * @param string|null $label_text_close label_text_close
     *
     * @return self
     */
    public function setLabelTextClose($label_text_close)
    {
        if (is_null($label_text_close)) {
            throw new \InvalidArgumentException('non-nullable label_text_close cannot be null');
        }
        $this->container['label_text_close'] = $label_text_close;

        return $this;
    }

    /**
     * Gets label_text_color_close
     *
     * @return string|null
     */
    public function getLabelTextColorClose()
    {
        return $this->container['label_text_color_close'];
    }

    /**
     * Sets label_text_color_close
     *
     * @param string|null $label_text_color_close label_text_color_close
     *
     * @return self
     */
    public function setLabelTextColorClose($label_text_color_close)
    {
        if (is_null($label_text_color_close)) {
            throw new \InvalidArgumentException('non-nullable label_text_color_close cannot be null');
        }
        $this->container['label_text_color_close'] = $label_text_color_close;

        return $this;
    }

    /**
     * Gets label_background_color_close
     *
     * @return string|null
     */
    public function getLabelBackgroundColorClose()
    {
        return $this->container['label_background_color_close'];
    }

    /**
     * Sets label_background_color_close
     *
     * @param string|null $label_background_color_close label_background_color_close
     *
     * @return self
     */
    public function setLabelBackgroundColorClose($label_background_color_close)
    {
        if (is_null($label_background_color_close)) {
            throw new \InvalidArgumentException('non-nullable label_background_color_close cannot be null');
        }
        $this->container['label_background_color_close'] = $label_background_color_close;

        return $this;
    }

    /**
     * Gets icon_type_open
     *
     * @return string|null
     */
    public function getIconTypeOpen()
    {
        return $this->container['icon_type_open'];
    }

    /**
     * Sets icon_type_open
     *
     * @param string|null $icon_type_open icon_type_open
     *
     * @return self
     */
    public function setIconTypeOpen($icon_type_open)
    {
        if (is_null($icon_type_open)) {
            throw new \InvalidArgumentException('non-nullable icon_type_open cannot be null');
        }
        $allowedValues = $this->getIconTypeOpenAllowableValues();
        if (!in_array($icon_type_open, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'icon_type_open', must be one of '%s'",
                    $icon_type_open,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['icon_type_open'] = $icon_type_open;

        return $this;
    }

    /**
     * Gets icon_text_open
     *
     * @return string|null
     */
    public function getIconTextOpen()
    {
        return $this->container['icon_text_open'];
    }

    /**
     * Sets icon_text_open
     *
     * @param string|null $icon_text_open icon_text_open
     *
     * @return self
     */
    public function setIconTextOpen($icon_text_open)
    {
        if (is_null($icon_text_open)) {
            throw new \InvalidArgumentException('non-nullable icon_text_open cannot be null');
        }
        $this->container['icon_text_open'] = $icon_text_open;

        return $this;
    }

    /**
     * Gets icon_background_image_open
     *
     * @return string|null
     */
    public function getIconBackgroundImageOpen()
    {
        return $this->container['icon_background_image_open'];
    }

    /**
     * Sets icon_background_image_open
     *
     * @param string|null $icon_background_image_open icon_background_image_open
     *
     * @return self
     */
    public function setIconBackgroundImageOpen($icon_background_image_open)
    {
        if (is_null($icon_background_image_open)) {
            throw new \InvalidArgumentException('non-nullable icon_background_image_open cannot be null');
        }
        $this->container['icon_background_image_open'] = $icon_background_image_open;

        return $this;
    }

    /**
     * Gets icon_class_open
     *
     * @return string|null
     */
    public function getIconClassOpen()
    {
        return $this->container['icon_class_open'];
    }

    /**
     * Sets icon_class_open
     *
     * @param string|null $icon_class_open icon_class_open
     *
     * @return self
     */
    public function setIconClassOpen($icon_class_open)
    {
        if (is_null($icon_class_open)) {
            throw new \InvalidArgumentException('non-nullable icon_class_open cannot be null');
        }
        $this->container['icon_class_open'] = $icon_class_open;

        return $this;
    }

    /**
     * Gets icon_color_open
     *
     * @return string|null
     */
    public function getIconColorOpen()
    {
        return $this->container['icon_color_open'];
    }

    /**
     * Sets icon_color_open
     *
     * @param string|null $icon_color_open icon_color_open
     *
     * @return self
     */
    public function setIconColorOpen($icon_color_open)
    {
        if (is_null($icon_color_open)) {
            throw new \InvalidArgumentException('non-nullable icon_color_open cannot be null');
        }
        $this->container['icon_color_open'] = $icon_color_open;

        return $this;
    }

    /**
     * Gets icon_background_color_open
     *
     * @return string|null
     */
    public function getIconBackgroundColorOpen()
    {
        return $this->container['icon_background_color_open'];
    }

    /**
     * Sets icon_background_color_open
     *
     * @param string|null $icon_background_color_open icon_background_color_open
     *
     * @return self
     */
    public function setIconBackgroundColorOpen($icon_background_color_open)
    {
        if (is_null($icon_background_color_open)) {
            throw new \InvalidArgumentException('non-nullable icon_background_color_open cannot be null');
        }
        $this->container['icon_background_color_open'] = $icon_background_color_open;

        return $this;
    }

    /**
     * Gets icon_enabled_open
     *
     * @return string|null
     */
    public function getIconEnabledOpen()
    {
        return $this->container['icon_enabled_open'];
    }

    /**
     * Sets icon_enabled_open
     *
     * @param string|null $icon_enabled_open icon_enabled_open
     *
     * @return self
     */
    public function setIconEnabledOpen($icon_enabled_open)
    {
        if (is_null($icon_enabled_open)) {
            throw new \InvalidArgumentException('non-nullable icon_enabled_open cannot be null');
        }
        $this->container['icon_enabled_open'] = $icon_enabled_open;

        return $this;
    }

    /**
     * Gets icon_type_close
     *
     * @return string|null
     */
    public function getIconTypeClose()
    {
        return $this->container['icon_type_close'];
    }

    /**
     * Sets icon_type_close
     *
     * @param string|null $icon_type_close icon_type_close
     *
     * @return self
     */
    public function setIconTypeClose($icon_type_close)
    {
        if (is_null($icon_type_close)) {
            throw new \InvalidArgumentException('non-nullable icon_type_close cannot be null');
        }
        $allowedValues = $this->getIconTypeCloseAllowableValues();
        if (!in_array($icon_type_close, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'icon_type_close', must be one of '%s'",
                    $icon_type_close,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['icon_type_close'] = $icon_type_close;

        return $this;
    }

    /**
     * Gets icon_text_close
     *
     * @return string|null
     */
    public function getIconTextClose()
    {
        return $this->container['icon_text_close'];
    }

    /**
     * Sets icon_text_close
     *
     * @param string|null $icon_text_close icon_text_close
     *
     * @return self
     */
    public function setIconTextClose($icon_text_close)
    {
        if (is_null($icon_text_close)) {
            throw new \InvalidArgumentException('non-nullable icon_text_close cannot be null');
        }
        $this->container['icon_text_close'] = $icon_text_close;

        return $this;
    }

    /**
     * Gets icon_background_image_close
     *
     * @return string|null
     */
    public function getIconBackgroundImageClose()
    {
        return $this->container['icon_background_image_close'];
    }

    /**
     * Sets icon_background_image_close
     *
     * @param string|null $icon_background_image_close icon_background_image_close
     *
     * @return self
     */
    public function setIconBackgroundImageClose($icon_background_image_close)
    {
        if (is_null($icon_background_image_close)) {
            throw new \InvalidArgumentException('non-nullable icon_background_image_close cannot be null');
        }
        $this->container['icon_background_image_close'] = $icon_background_image_close;

        return $this;
    }

    /**
     * Gets icon_class_close
     *
     * @return string|null
     */
    public function getIconClassClose()
    {
        return $this->container['icon_class_close'];
    }

    /**
     * Sets icon_class_close
     *
     * @param string|null $icon_class_close icon_class_close
     *
     * @return self
     */
    public function setIconClassClose($icon_class_close)
    {
        if (is_null($icon_class_close)) {
            throw new \InvalidArgumentException('non-nullable icon_class_close cannot be null');
        }
        $this->container['icon_class_close'] = $icon_class_close;

        return $this;
    }

    /**
     * Gets icon_color_close
     *
     * @return string|null
     */
    public function getIconColorClose()
    {
        return $this->container['icon_color_close'];
    }

    /**
     * Sets icon_color_close
     *
     * @param string|null $icon_color_close icon_color_close
     *
     * @return self
     */
    public function setIconColorClose($icon_color_close)
    {
        if (is_null($icon_color_close)) {
            throw new \InvalidArgumentException('non-nullable icon_color_close cannot be null');
        }
        $this->container['icon_color_close'] = $icon_color_close;

        return $this;
    }

    /**
     * Gets icon_background_color_close
     *
     * @return string|null
     */
    public function getIconBackgroundColorClose()
    {
        return $this->container['icon_background_color_close'];
    }

    /**
     * Sets icon_background_color_close
     *
     * @param string|null $icon_background_color_close icon_background_color_close
     *
     * @return self
     */
    public function setIconBackgroundColorClose($icon_background_color_close)
    {
        if (is_null($icon_background_color_close)) {
            throw new \InvalidArgumentException('non-nullable icon_background_color_close cannot be null');
        }
        $this->container['icon_background_color_close'] = $icon_background_color_close;

        return $this;
    }

    /**
     * Gets icon_enabled_close
     *
     * @return string|null
     */
    public function getIconEnabledClose()
    {
        return $this->container['icon_enabled_close'];
    }

    /**
     * Sets icon_enabled_close
     *
     * @param string|null $icon_enabled_close icon_enabled_close
     *
     * @return self
     */
    public function setIconEnabledClose($icon_enabled_close)
    {
        if (is_null($icon_enabled_close)) {
            throw new \InvalidArgumentException('non-nullable icon_enabled_close cannot be null');
        }
        $this->container['icon_enabled_close'] = $icon_enabled_close;

        return $this;
    }

    /**
     * Gets default_state
     *
     * @return string|null
     */
    public function getDefaultState()
    {
        return $this->container['default_state'];
    }

    /**
     * Sets default_state
     *
     * @param string|null $default_state default_state
     *
     * @return self
     */
    public function setDefaultState($default_state)
    {
        if (is_null($default_state)) {
            throw new \InvalidArgumentException('non-nullable default_state cannot be null');
        }
        $allowedValues = $this->getDefaultStateAllowableValues();
        if (!in_array($default_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'default_state', must be one of '%s'",
                    $default_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['default_state'] = $default_state;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


